/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.swing;

import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.CheckboxPeer;
import dorkbox.systemTray.ui.swing.SwingMenu;
import dorkbox.systemTray.ui.swing.SwingMenuItem;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.systemTray.util.HeavyCheckMark;
import dorkbox.util.FontUtil;
import dorkbox.util.SwingUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

class SwingMenuItemCheckbox
extends SwingMenuItem
implements CheckboxPeer {
    private volatile boolean isChecked = false;
    private static ImageIcon checkedIcon;

    protected static void createCheckedIcon(int n) {
        if (checkedIcon == null) {
            try {
                JMenuItem jMenuItem = new JMenuItem();
                if (SystemTray.SWING_UI != null) {
                    jMenuItem.setUI(SystemTray.SWING_UI.getItemUI(jMenuItem, null));
                }
                int n2 = FontUtil.INSTANCE.getFontHeight(jMenuItem.getFont(), "X");
                String string = SystemTray.SWING_UI != null ? SystemTray.SWING_UI.getCheckMarkIcon(jMenuItem.getForeground(), n2, n) : HeavyCheckMark.get(jMenuItem.getForeground(), n2, n);
                checkedIcon = new ImageIcon(string);
                return;
            }
            catch (Exception exception) {
                SystemTray.logger.error("Error creating check-mark image.", (Throwable)exception);
            }
        }
    }

    SwingMenuItemCheckbox(SwingMenu swingMenu, Entry entry, int n) {
        super(swingMenu, entry, n);
    }

    @Override
    public void setEnabled(Checkbox checkbox) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(checkbox.getEnabled()));
    }

    @Override
    public void setText(Checkbox checkbox) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setText(checkbox.getText()));
    }

    @Override
    public void setCallback(final Checkbox checkbox) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = checkbox.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = checkbox.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    checkbox.setChecked(!SwingMenuItemCheckbox.this.isChecked);
                    1 v0 = this;
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(v0.checkbox, 1001, ""));
                            return;
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu checkbox entry {} click event.", (Object)v0.checkbox.getText(), (Object)throwable);
                            return;
                        }
                    });
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(Checkbox checkbox) {
        int n = SwingUtil.INSTANCE.getVirtualKey(checkbox.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setMnemonic(n));
    }

    @Override
    public void setChecked(Checkbox checkbox) {
        boolean bl = checkbox.getChecked();
        if (bl != this.isChecked) {
            this.isChecked = bl;
            SwingUtil.INSTANCE.invokeLater(() -> {
                if (this.isChecked) {
                    this._native.setIcon(checkedIcon);
                    return;
                }
                this._native.setIcon(SwingMenuItem.transparentIcon);
            });
        }
    }

    @Override
    public void setTooltip(Checkbox checkbox) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setToolTipText(checkbox.getTooltip()));
    }
}

