/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.SizeAndScaling;
import dorkbox.util.CacheUtil;
import dorkbox.util.IO;
import dorkbox.util.ImageUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;

public class ImageResizeUtil {
    private static final Pattern JAR_URL_REGEX = Pattern.compile(".*.jar!.*");
    private final CacheUtil cache;

    public ImageResizeUtil(CacheUtil cacheUtil) {
        this.cache = cacheUtil;
    }

    public File getTransparentImage() {
        return this.getTransparentImage(4);
    }

    public File getTransparentImage(int n) {
        try {
            File file = this.cache.create(n + "_empty.png");
            return ImageUtil.createImage((int)n, (File)file, null);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Unable to generate transparent image! Something is severely wrong!");
        }
    }

    public synchronized File getErrorImage(int n) {
        if (n <= 0) {
            n = 32;
        }
        try {
            InputStream inputStream = ImageResizeUtil.class.getResource("error_32.png").openStream();
            inputStream = ImageResizeUtil.makeByteArrayInputStream(inputStream);
            inputStream.mark(0);
            String string = n + "_" + CacheUtil.Companion.createNameAsHash(inputStream);
            ((ByteArrayInputStream)inputStream).reset();
            File file = this.cache.check(string);
            if (file != null) {
                return file;
            }
            File file2 = this.resizeFileNoCheck(n, inputStream);
            return this.cache.save(string, file2);
        }
        catch (Exception exception) {
            throw new RuntimeException("Serious problems! Unable to extract error image, this should NEVER happen!", exception);
        }
    }

    private File resizeAndCache(int n, File file) {
        return this.resizeAndCache(n, file.getAbsolutePath());
    }

    /*
     * Loose catch block
     */
    private File resizeAndCache(int n, String object) {
        InputStream inputStream;
        block15: {
            if (object == null) {
                return null;
            }
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image to " + n + " : " + (String)object);
            }
            inputStream = null;
            if (JAR_URL_REGEX.matcher((CharSequence)object).matches()) {
                object = new URL((String)object);
                inputStream = ((URL)object).openStream();
            } else {
                inputStream = new FileInputStream((String)object);
            }
            object = this.resizeAndCache(n, inputStream);
            if (inputStream == null) break block15;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
        return object;
        catch (Exception exception) {
            File file;
            block16: {
                try {
                    SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)exception);
                    file = this.getErrorImage(n);
                    if (inputStream == null) break block16;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            return file;
        }
    }

    private synchronized File resizeAndCache(int n, InputStream inputStream) {
        Serializable serializable;
        String string;
        if (inputStream == null) {
            return null;
        }
        boolean bl = true;
        try {
            inputStream = ImageResizeUtil.makeByteArrayInputStream(inputStream);
            inputStream.mark(0);
            string = n + "_" + CacheUtil.Companion.createNameAsHash(inputStream);
            ((ByteArrayInputStream)inputStream).reset();
            serializable = this.cache.check(string);
            if (serializable != null && ((File)serializable).canRead()) {
                return serializable;
            }
            inputStream.mark(0);
            serializable = ImageUtil.getImageSize((InputStream)inputStream);
            if (n == (int)((Dimension)serializable).getHeight() && n == (int)((Dimension)serializable).getWidth()) {
                bl = false;
            }
        }
        catch (Exception exception) {
            SystemTray.logger.error("Error getting image size. Using error icon instead", (Throwable)exception);
            File file = this.getErrorImage(n);
            return file;
        }
        finally {
            ((ByteArrayInputStream)inputStream).reset();
        }
        if (bl) {
            try {
                serializable = this.resizeFileNoCheck(n, inputStream);
                try {
                    return this.cache.save(string, (File)serializable);
                }
                catch (Exception exception) {
                    SystemTray.logger.error("Error caching image. Using error icon instead", (Throwable)exception);
                    return this.getErrorImage(n);
                }
            }
            catch (Exception exception) {
                SystemTray.logger.error("Error resizing image. Using error icon instead", (Throwable)exception);
                return this.getErrorImage(n);
            }
        }
        try {
            return this.cache.save(string, inputStream);
        }
        catch (Exception exception) {
            SystemTray.logger.error("Error caching image. Using error icon instead", (Throwable)exception);
            return this.getErrorImage(n);
        }
    }

    private static InputStream makeByteArrayInputStream(InputStream inputStream) {
        if (!(inputStream instanceof ByteArrayInputStream)) {
            ByteArrayOutputStream byteArrayOutputStream = IO.copyStream((InputStream)inputStream);
            inputStream.close();
            inputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        }
        return inputStream;
    }

    private File resizeFileNoCheck(int n, InputStream object) {
        File file = this.cache.create("temp_resize.png");
        file.delete();
        object = ImageIO.read((InputStream)object);
        ImageUtil.waitForImageLoad((Image)object);
        object = ImageUtil.getBufferedImage((Image)object);
        int n2 = ((BufferedImage)object).getWidth();
        int n3 = ((BufferedImage)object).getHeight();
        object = n2 > n3 ? ImageUtil.resizeImage((BufferedImage)object, (int)n, (int)-1) : ImageUtil.resizeImage((BufferedImage)object, (int)-1, (int)n);
        object = ImageUtil.getSquareBufferedImage((Image)object);
        ImageIO.write((RenderedImage)object, "png", file);
        return file;
    }

    /*
     * WARNING - void declaration
     */
    public File shouldResizeOrCache(boolean bl, File file) {
        void var2_3;
        if (var2_3 == null) {
            return null;
        }
        if (SystemTray.AUTO_SIZE) {
            int n = ImageResizeUtil.getSize(bl);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image to " + n + " : " + var2_3);
            }
            return this.resizeAndCache(n, (File)var2_3);
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public File shouldResizeOrCache(boolean bl, String string) {
        void var2_3;
        if (var2_3 == null) {
            return null;
        }
        if (SystemTray.AUTO_SIZE) {
            int n = ImageResizeUtil.getSize(bl);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image to " + n + " : " + (String)var2_3);
            }
            return this.resizeAndCache(n, (String)var2_3);
        }
        return new File((String)var2_3);
    }

    public File shouldResizeOrCache(boolean bl, URL object) {
        InputStream exception;
        if (exception == null) {
            return null;
        }
        int n = ImageResizeUtil.getSize(bl);
        try {
            if (SystemTray.AUTO_SIZE) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Resizing image to " + n + " : " + exception);
                }
                exception = ((URL)((Object)exception)).openStream();
                File file = this.resizeAndCache(n, exception);
                exception.close();
                return file;
            }
            return this.cache.save((URL)((Object)exception));
        }
        catch (Exception exception2) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)exception2);
            return this.getErrorImage(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public File shouldResizeOrCache(boolean bl, InputStream inputStream) {
        void iOException;
        if (iOException == null) {
            return null;
        }
        int n = ImageResizeUtil.getSize(bl);
        if (SystemTray.AUTO_SIZE) {
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Resizing image-stream to " + n);
            }
            return this.resizeAndCache(n, (InputStream)iOException);
        }
        try {
            return this.cache.save((InputStream)iOException);
        }
        catch (IOException iOException2) {
            SystemTray.logger.error("Error checking cache for information. Using error icon instead", (Throwable)iOException2);
            return this.getErrorImage(n);
        }
    }

    public File shouldResizeOrCache(boolean bl, Image object) {
        Object exception;
        if (exception == null) {
            return null;
        }
        int n = ImageResizeUtil.getSize(bl);
        try {
            ImageUtil.waitForImageLoad((Image)exception);
            exception = ImageUtil.getBufferedImage((Image)exception);
            Object object2 = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)exception, "png", (OutputStream)object2);
            exception = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
            if (SystemTray.AUTO_SIZE) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Resizing image to " + n);
                }
                object2 = this.resizeAndCache(n, (InputStream)exception);
            } else {
                object2 = this.cache.save((InputStream)exception);
            }
            ((InputStream)exception).close();
            return object2;
        }
        catch (Exception exception2) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)exception2);
            return this.getErrorImage(n);
        }
    }

    public File shouldResizeOrCache(boolean bl, ImageInputStream closeable) {
        Closeable exception;
        if (exception == null) {
            return null;
        }
        int n = ImageResizeUtil.getSize(bl);
        try {
            exception = IO.copyStream((ImageInputStream)exception);
            exception = new ByteArrayInputStream(exception.toByteArray());
            if (SystemTray.AUTO_SIZE) {
                if (SystemTray.DEBUG) {
                    SystemTray.logger.debug("Resizing image-stream to " + n);
                }
                return this.resizeAndCache(n, (InputStream)exception);
            }
            return this.cache.save((InputStream)exception);
        }
        catch (Exception exception2) {
            SystemTray.logger.error("Error reading image. Using error icon instead", (Throwable)exception2);
            return this.getErrorImage(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static int getSize(boolean bl) {
        void var0_3;
        if (bl) {
            int n = SizeAndScaling.TRAY_SIZE;
        } else {
            int n = SizeAndScaling.TRAY_MENU_SIZE;
        }
        return (int)var0_3;
    }
}

