/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public final class HostsFileEntriesProvider {
    static final HostsFileEntriesProvider EMPTY = new HostsFileEntriesProvider(Collections.<String, List<InetAddress>>emptyMap(), Collections.<String, List<InetAddress>>emptyMap());
    private final Map<String, List<InetAddress>> ipv4Entries;
    private final Map<String, List<InetAddress>> ipv6Entries;

    public static Parser parser() {
        return ParserImpl.INSTANCE;
    }

    HostsFileEntriesProvider(Map<String, List<InetAddress>> map, Map<String, List<InetAddress>> map2) {
        this.ipv4Entries = Collections.unmodifiableMap(new HashMap<String, List<InetAddress>>(map));
        this.ipv6Entries = Collections.unmodifiableMap(new HashMap<String, List<InetAddress>>(map2));
    }

    public final Map<String, List<InetAddress>> ipv4Entries() {
        return this.ipv4Entries;
    }

    public final Map<String, List<InetAddress>> ipv6Entries() {
        return this.ipv6Entries;
    }

    private static final class ParserImpl
    implements Parser {
        private static final String WINDOWS_DEFAULT_SYSTEM_ROOT = "C:\\Windows";
        private static final String WINDOWS_HOSTS_FILE_RELATIVE_PATH = "\\system32\\drivers\\etc\\hosts";
        private static final String X_PLATFORMS_HOSTS_FILE_PATH = "/etc/hosts";
        private static final Pattern WHITESPACES = Pattern.compile("[ \t]+");
        private static final InternalLogger logger = InternalLoggerFactory.getInstance(Parser.class);
        static final ParserImpl INSTANCE = new ParserImpl();

        private ParserImpl() {
        }

        @Override
        public final HostsFileEntriesProvider parse() {
            return this.parse(ParserImpl.locateHostsFile(), Charset.defaultCharset());
        }

        @Override
        public final HostsFileEntriesProvider parse(Charset ... charsetArray) {
            return this.parse(ParserImpl.locateHostsFile(), charsetArray);
        }

        @Override
        public final HostsFileEntriesProvider parse(File object, Charset ... charsetArray) {
            ObjectUtil.checkNotNull((Object)object, (String)"file");
            ObjectUtil.checkNotNull((Object)charsetArray, (String)"charsets");
            if (charsetArray.length == 0) {
                charsetArray = new Charset[]{Charset.defaultCharset()};
            }
            if (((File)object).exists() && ((File)object).isFile()) {
                for (Charset charset : charsetArray) {
                    BufferedReader object2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)object), charset));
                    try {
                        HostsFileEntriesProvider hostsFileEntriesProvider = this.parse(object2);
                        if (hostsFileEntriesProvider == EMPTY) continue;
                        object = hostsFileEntriesProvider;
                        return object;
                    }
                    finally {
                        object2.close();
                    }
                }
            }
            return EMPTY;
        }

        @Override
        public final HostsFileEntriesProvider parse(Reader reader) {
            ObjectUtil.checkNotNull((Object)reader, (String)"reader");
            reader = new BufferedReader(reader);
            try {
                Object[] objectArray;
                HashMap<String, List<InetAddress>> hashMap = new HashMap<String, List<InetAddress>>();
                HashMap<String, List<InetAddress>> hashMap2 = new HashMap<String, List<InetAddress>>();
                while ((objectArray = ((BufferedReader)reader).readLine()) != null) {
                    String string;
                    int n = objectArray.indexOf(35);
                    if (n != -1) {
                        objectArray = objectArray.substring(0, n);
                    }
                    if ((objectArray = objectArray.trim()).isEmpty()) continue;
                    ArrayList<String> arrayList = new ArrayList<String>();
                    objectArray = WHITESPACES.split((CharSequence)objectArray);
                    n = objectArray.length;
                    for (int i = 0; i < n; ++i) {
                        string = objectArray[i];
                        if (string.isEmpty()) continue;
                        arrayList.add(string);
                    }
                    if (arrayList.size() < 2) continue;
                    byte[] byArray = NetUtil.createByteArrayFromIpAddressString((String)((String)arrayList.get(0)));
                    objectArray = byArray;
                    if (byArray == null) continue;
                    for (n = 1; n < arrayList.size(); ++n) {
                        List<Object> list;
                        Object object = (String)arrayList.get(n);
                        string = ((String)object).toLowerCase(Locale.ENGLISH);
                        if ((object = InetAddress.getByAddress((String)object, (byte[])objectArray)) instanceof Inet4Address) {
                            list = (ArrayList<Object>)hashMap.get(string);
                            if (list == null) {
                                list = new ArrayList<Object>();
                                hashMap.put(string, list);
                            }
                        } else {
                            list = (List)hashMap2.get(string);
                            if (list == null) {
                                list = new ArrayList();
                                hashMap2.put(string, list);
                            }
                        }
                        list.add(object);
                    }
                }
                HostsFileEntriesProvider hostsFileEntriesProvider = hashMap.isEmpty() && hashMap2.isEmpty() ? EMPTY : new HostsFileEntriesProvider(hashMap, hashMap2);
                return hostsFileEntriesProvider;
            }
            finally {
                try {
                    ((BufferedReader)reader).close();
                }
                catch (IOException iOException) {
                    logger.warn("Failed to close a reader", (Throwable)iOException);
                }
            }
        }

        @Override
        public final HostsFileEntriesProvider parseSilently() {
            return this.parseSilently(ParserImpl.locateHostsFile(), Charset.defaultCharset());
        }

        @Override
        public final HostsFileEntriesProvider parseSilently(Charset ... charsetArray) {
            return this.parseSilently(ParserImpl.locateHostsFile(), charsetArray);
        }

        @Override
        public final HostsFileEntriesProvider parseSilently(File file, Charset ... charsetArray) {
            try {
                return this.parse(file, charsetArray);
            }
            catch (IOException iOException) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Failed to load and parse hosts file at " + file.getPath(), (Throwable)iOException);
                }
                return EMPTY;
            }
        }

        private static File locateHostsFile() {
            File file;
            if (PlatformDependent.isWindows()) {
                file = new File(System.getenv("SystemRoot") + WINDOWS_HOSTS_FILE_RELATIVE_PATH);
                if (!file.exists()) {
                    file = new File("C:\\Windows\\system32\\drivers\\etc\\hosts");
                }
            } else {
                file = new File(X_PLATFORMS_HOSTS_FILE_PATH);
            }
            return file;
        }
    }

    public static interface Parser {
        public HostsFileEntriesProvider parse();

        public HostsFileEntriesProvider parse(Charset ... var1);

        public HostsFileEntriesProvider parse(File var1, Charset ... var2);

        public HostsFileEntriesProvider parse(Reader var1);

        public HostsFileEntriesProvider parseSilently();

        public HostsFileEntriesProvider parseSilently(Charset ... var1);

        public HostsFileEntriesProvider parseSilently(File var1, Charset ... var2);
    }
}

