/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.packet;

import org.jivesoftware.smack.packet.StreamOpen;
import org.jivesoftware.smack.util.ParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;

public class XmlEnvironment {
    public static final XmlEnvironment EMPTY = new XmlEnvironment(null);
    private final String namespace;
    private final String language;
    private final XmlEnvironment next;
    private transient boolean effectiveNamespaceDetermined;
    private transient boolean effectiveLanguageDetermined;
    private transient String effectiveNamespace;
    private transient String effectiveLanguage;
    private transient String toStringCache;

    public XmlEnvironment(String string) {
        this(string, null);
    }

    public XmlEnvironment(String string, String string2) {
        this(string, string2, null);
    }

    private XmlEnvironment(Builder builder) {
        this(builder.namespace, builder.language, builder.next);
    }

    public XmlEnvironment(String string, String string2, XmlEnvironment xmlEnvironment) {
        this.namespace = string;
        this.language = string2;
        this.next = xmlEnvironment;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getEffectiveNamespace() {
        if (this.effectiveNamespaceDetermined) {
            return this.effectiveNamespace;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.namespace)) {
            this.effectiveNamespace = this.namespace;
        } else if (this.next != null) {
            this.effectiveNamespace = this.next.getEffectiveNamespace();
        }
        this.effectiveNamespaceDetermined = true;
        return this.effectiveNamespace;
    }

    public String getEffectiveNamespaceOrUse(String string) {
        String string2 = this.getEffectiveNamespace();
        if (StringUtils.isNullOrEmpty((CharSequence)string2)) {
            return string;
        }
        return string2;
    }

    public boolean effectiveNamespaceEquals(String string) {
        String string2 = this.getEffectiveNamespace();
        if (string2 == null) {
            return false;
        }
        return string2.equals(string);
    }

    public String getLanguage() {
        return this.language;
    }

    public String getEffectiveLanguage() {
        if (this.effectiveLanguageDetermined) {
            return this.effectiveLanguage;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.language)) {
            this.effectiveLanguage = this.language;
        } else if (this.next != null) {
            this.effectiveLanguage = this.next.getEffectiveLanguage();
        }
        this.effectiveLanguageDetermined = true;
        return this.effectiveLanguage;
    }

    public boolean effectiveLanguageEquals(String string) {
        String string2 = this.getEffectiveLanguage();
        if (string2 == null) {
            return false;
        }
        return string2.equals(string);
    }

    public String toString() {
        if (this.toStringCache == null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(XmlEnvironment.class.getSimpleName()).append(' ');
            stringBuilder.append("xmlns=").append(this.getEffectiveNamespace()).append(' ');
            stringBuilder.append("xmllang=").append(this.getEffectiveLanguage()).append(' ');
            this.toStringCache = stringBuilder.toString();
        }
        return this.toStringCache;
    }

    public static XmlEnvironment from(XmlPullParser xmlPullParser) {
        return XmlEnvironment.from(xmlPullParser, null);
    }

    public static XmlEnvironment from(XmlPullParser object, XmlEnvironment xmlEnvironment) {
        String string = object.getDefaultNamespace();
        object = ParserUtils.getXmlLang(object);
        return new XmlEnvironment(string, (String)object, xmlEnvironment);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String namespace;
        private String language;
        private XmlEnvironment next;

        public Builder withNamespace(String string) {
            this.namespace = string;
            return this;
        }

        public Builder withLanguage(String string) {
            this.language = string;
            return this;
        }

        public Builder withNext(XmlEnvironment xmlEnvironment) {
            this.next = xmlEnvironment;
            return this;
        }

        public Builder with(StreamOpen streamOpen) {
            this.withNamespace(streamOpen.getNamespace());
            this.withLanguage(streamOpen.getLanguage());
            return this;
        }

        public XmlEnvironment build() {
            return new XmlEnvironment(this);
        }
    }
}

