/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.Smack;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.provider.ExtensionElementProvider;
import org.jivesoftware.smack.provider.ExtensionProviderInfo;
import org.jivesoftware.smack.provider.IQProviderInfo;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.provider.NonzaProvider;
import org.jivesoftware.smack.provider.ProviderLoader;
import org.jivesoftware.smack.provider.StreamFeatureProviderInfo;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmppElementUtil;

public final class ProviderManager {
    private static final Map<QName, ExtensionElementProvider<ExtensionElement>> extensionProviders = new ConcurrentHashMap<QName, ExtensionElementProvider<ExtensionElement>>();
    private static final Map<QName, IqProvider<IQ>> iqProviders = new ConcurrentHashMap<QName, IqProvider<IQ>>();
    private static final Map<QName, ExtensionElementProvider<ExtensionElement>> streamFeatureProviders = new ConcurrentHashMap<QName, ExtensionElementProvider<ExtensionElement>>();
    private static final Map<QName, NonzaProvider<? extends Nonza>> nonzaProviders = new ConcurrentHashMap<QName, NonzaProvider<? extends Nonza>>();

    public static void addLoader(ProviderLoader providerLoader) {
        if (providerLoader.getIQProviderInfo() != null) {
            for (IQProviderInfo abstractProviderInfo : providerLoader.getIQProviderInfo()) {
                ProviderManager.addIQProvider(abstractProviderInfo.getElementName(), abstractProviderInfo.getNamespace(), abstractProviderInfo.getProvider());
            }
        }
        if (providerLoader.getExtensionProviderInfo() != null) {
            for (ExtensionProviderInfo extensionProviderInfo : providerLoader.getExtensionProviderInfo()) {
                ProviderManager.addExtensionProvider(extensionProviderInfo.getElementName(), extensionProviderInfo.getNamespace(), extensionProviderInfo.getProvider());
            }
        }
        if (providerLoader.getStreamFeatureProviderInfo() != null) {
            for (StreamFeatureProviderInfo streamFeatureProviderInfo : providerLoader.getStreamFeatureProviderInfo()) {
                ProviderManager.addStreamFeatureProvider(streamFeatureProviderInfo.getElementName(), streamFeatureProviderInfo.getNamespace(), (ExtensionElementProvider)streamFeatureProviderInfo.getProvider());
            }
        }
    }

    public static IqProvider<IQ> getIQProvider(String object, String string) {
        object = ProviderManager.getQName((String)object, string);
        return iqProviders.get(object);
    }

    public static List<IqProvider<IQ>> getIQProviders() {
        ArrayList<IqProvider<IQ>> arrayList = new ArrayList<IqProvider<IQ>>(iqProviders.size());
        arrayList.addAll(iqProviders.values());
        return arrayList;
    }

    public static void addIQProvider(String object, String string, Object object2) {
        ProviderManager.validate((String)object, string);
        object = ProviderManager.removeIQProvider((String)object, string);
        if (object2 instanceof IqProvider) {
            iqProviders.put((QName)object, (IqProvider)object2);
            return;
        }
        throw new IllegalArgumentException("Provider must be an instance of IqProvider");
    }

    public static QName removeIQProvider(String object, String string) {
        object = ProviderManager.getQName((String)object, string);
        iqProviders.remove(object);
        return object;
    }

    public static ExtensionElementProvider<ExtensionElement> getExtensionProvider(String object, String string) {
        object = ProviderManager.getQName((String)object, string);
        return ProviderManager.getExtensionProvider((QName)object);
    }

    public static ExtensionElementProvider<ExtensionElement> getExtensionProvider(QName qName) {
        return extensionProviders.get(qName);
    }

    public static void addExtensionProvider(String object, String string, Object object2) {
        ProviderManager.validate((String)object, string);
        object = ProviderManager.removeExtensionProvider((String)object, string);
        if (object2 instanceof ExtensionElementProvider) {
            extensionProviders.put((QName)object, (ExtensionElementProvider)object2);
            return;
        }
        throw new IllegalArgumentException("Provider must be a PacketExtensionProvider");
    }

    public static QName removeExtensionProvider(String object, String string) {
        object = ProviderManager.getQName((String)object, string);
        extensionProviders.remove(object);
        return object;
    }

    public static List<ExtensionElementProvider<ExtensionElement>> getExtensionProviders() {
        ArrayList<ExtensionElementProvider<ExtensionElement>> arrayList = new ArrayList<ExtensionElementProvider<ExtensionElement>>(extensionProviders.size());
        arrayList.addAll(extensionProviders.values());
        return arrayList;
    }

    public static ExtensionElementProvider<ExtensionElement> getStreamFeatureProvider(String object, String string) {
        object = ProviderManager.getQName((String)object, string);
        return streamFeatureProviders.get(object);
    }

    public static void addStreamFeatureProvider(String object, String string, ExtensionElementProvider<ExtensionElement> extensionElementProvider) {
        ProviderManager.validate((String)object, string);
        object = ProviderManager.getQName((String)object, string);
        streamFeatureProviders.put((QName)object, extensionElementProvider);
    }

    public static void removeStreamFeatureProvider(String object, String string) {
        object = ProviderManager.getQName((String)object, string);
        streamFeatureProviders.remove(object);
    }

    public static NonzaProvider<? extends Nonza> getNonzaProvider(String object, String string) {
        object = ProviderManager.getQName((String)object, string);
        return ProviderManager.getNonzaProvider((QName)object);
    }

    public static NonzaProvider<? extends Nonza> getNonzaProvider(QName qName) {
        return nonzaProviders.get(qName);
    }

    public static void addNonzaProvider(NonzaProvider<? extends Nonza> nonzaProvider) {
        Serializable serializable = nonzaProvider.getElementClass();
        serializable = XmppElementUtil.getQNameFor(serializable);
        nonzaProviders.put((QName)serializable, nonzaProvider);
    }

    public static void removeNonzaProvider(Class<? extends Nonza> serializable) {
        serializable = XmppElementUtil.getQNameFor(serializable);
        nonzaProviders.remove(serializable);
    }

    public static void removeNonzaProvider(String object, String string) {
        object = ProviderManager.getQName((String)object, string);
        nonzaProviders.remove(object);
    }

    private static QName getQName(String string, String string2) {
        return new QName(string2, string);
    }

    private static void validate(String string, String string2) {
        if (StringUtils.isNullOrEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("elementName must not be null or empty");
        }
        if (StringUtils.isNullOrEmpty((CharSequence)string2)) {
            throw new IllegalArgumentException("namespace must not be null or empty");
        }
    }

    static {
        Smack.ensureInitialized();
    }
}

