/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class EventManger<K, R, E extends Exception> {
    private final Map<K, Reference<R>> events = new ConcurrentHashMap<K, Reference<R>>();

    public R performActionAndWaitForEvent(K k, long l, Callback<E> callback) {
        Reference reference = new Reference();
        this.events.put(k, reference);
        try {
            Reference reference2 = reference;
            synchronized (reference2) {
                callback.action();
                reference.wait(l);
            }
            reference2 = reference.eventResult;
            return (R)reference2;
        }
        finally {
            this.events.remove(k);
        }
    }

    public boolean signalEvent(K object, R object2) {
        if ((object = this.events.get(object)) == null) {
            return false;
        }
        ((Reference)object).eventResult = object2;
        object2 = object;
        synchronized (object2) {
            object.notifyAll();
        }
        return true;
    }

    public static interface Callback<E extends Exception> {
        public void action();
    }

    private static class Reference<V> {
        volatile V eventResult;

        private Reference() {
        }
    }
}

