/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ClassicConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import org.slf4j.event.KeyValuePair;

public class KeyValuePairConverter
extends ClassicConverter {
    static final String DOUBLE_OPTION_STR = "DOUBLE";
    static final String SINGLE_OPTION_STR = "SINGLE";
    static final String NONE_OPTION_STR = "NONE";
    ValueQuoteSpecification valueQuoteSpec = ValueQuoteSpecification.DOUBLE;

    public void start() {
        String string = this.getFirstOption();
        this.valueQuoteSpec = this.optionStrToSpec(string);
        super.start();
    }

    private ValueQuoteSpecification optionStrToSpec(String string) {
        if (string == null) {
            return ValueQuoteSpecification.DOUBLE;
        }
        if (DOUBLE_OPTION_STR.equalsIgnoreCase(string)) {
            return ValueQuoteSpecification.DOUBLE;
        }
        if (SINGLE_OPTION_STR.equalsIgnoreCase(string)) {
            return ValueQuoteSpecification.SINGLE;
        }
        if (NONE_OPTION_STR.equalsIgnoreCase(string)) {
            return ValueQuoteSpecification.NONE;
        }
        return ValueQuoteSpecification.DOUBLE;
    }

    public String convert(ILoggingEvent object) {
        if ((object = object.getKeyValuePairs()) == null || object.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < object.size(); ++i) {
            KeyValuePair keyValuePair = (KeyValuePair)object.get(i);
            if (i != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(String.valueOf(keyValuePair.key));
            stringBuilder.append('=');
            Character c = this.valueQuoteSpec.asChar();
            if (c != null) {
                stringBuilder.append(c);
            }
            stringBuilder.append(String.valueOf(keyValuePair.value));
            if (c == null) continue;
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    static enum ValueQuoteSpecification {
        NONE,
        SINGLE,
        DOUBLE;


        final Character asChar() {
            switch (this.ordinal()) {
                case 0: {
                    return null;
                }
                case 2: {
                    return Character.valueOf('\"');
                }
                case 1: {
                    return Character.valueOf('\'');
                }
            }
            throw new IllegalStateException();
        }
    }
}

