/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.pattern;

import ch.qos.logback.classic.pattern.ThrowableHandlingConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxyUtil;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.boolex.EvaluationException;
import ch.qos.logback.core.boolex.EventEvaluator;
import ch.qos.logback.core.status.ErrorStatus;
import ch.qos.logback.core.status.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ThrowableProxyConverter
extends ThrowableHandlingConverter {
    protected static final int BUILDER_CAPACITY = 2048;
    int lengthOption;
    List<EventEvaluator<ILoggingEvent>> evaluatorList = null;
    List<String> ignoredStackTraceLines = null;
    int errorCount = 0;

    public void start() {
        Object object = this.getFirstOption();
        if (object == null) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("full".equals(object = ((String)object).toLowerCase())) {
            this.lengthOption = Integer.MAX_VALUE;
        } else if ("short".equals(object)) {
            this.lengthOption = 1;
        } else {
            try {
                this.lengthOption = Integer.parseInt((String)object);
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("Could not parse [" + (String)object + "] as an integer");
                this.lengthOption = Integer.MAX_VALUE;
            }
        }
        object = this.getOptionList();
        if (object != null && object.size() > 1) {
            int n = object.size();
            for (int i = 1; i < n; ++i) {
                String string = (String)object.get(i);
                Object object2 = this.getContext();
                object2 = (Map)object2.getObject("EVALUATOR_MAP");
                if ((object2 = (EventEvaluator)object2.get(string)) != null) {
                    this.addEvaluator((EventEvaluator<ILoggingEvent>)object2);
                    continue;
                }
                this.addIgnoreStackTraceLine(string);
            }
        }
        super.start();
    }

    private void addEvaluator(EventEvaluator<ILoggingEvent> eventEvaluator) {
        if (this.evaluatorList == null) {
            this.evaluatorList = new ArrayList<EventEvaluator<ILoggingEvent>>();
        }
        this.evaluatorList.add(eventEvaluator);
    }

    private void addIgnoreStackTraceLine(String string) {
        if (this.ignoredStackTraceLines == null) {
            this.ignoredStackTraceLines = new ArrayList<String>();
        }
        this.ignoredStackTraceLines.add(string);
    }

    public void stop() {
        this.evaluatorList = null;
        super.stop();
    }

    protected void extraData(StringBuilder stringBuilder, StackTraceElementProxy stackTraceElementProxy) {
    }

    public String convert(ILoggingEvent iLoggingEvent) {
        IThrowableProxy iThrowableProxy = iLoggingEvent.getThrowableProxy();
        if (iThrowableProxy == null) {
            return "";
        }
        if (this.evaluatorList != null) {
            boolean bl = true;
            for (int i = 0; i < this.evaluatorList.size(); ++i) {
                ErrorStatus errorStatus = this.evaluatorList.get(i);
                try {
                    if (!errorStatus.evaluate((Object)iLoggingEvent)) continue;
                    bl = false;
                    break;
                }
                catch (EvaluationException evaluationException) {
                    ++this.errorCount;
                    if (this.errorCount < 4) {
                        this.addError("Exception thrown for evaluator named [" + errorStatus.getName() + "]", evaluationException);
                        continue;
                    }
                    if (this.errorCount != 4) continue;
                    errorStatus = new ErrorStatus("Exception thrown for evaluator named [" + errorStatus.getName() + "].", (Object)this, (Throwable)evaluationException);
                    errorStatus.add((Status)new ErrorStatus("This was the last warning about this evaluator's errors.We don't want the StatusManager to get flooded.", (Object)this));
                    this.addStatus((Status)errorStatus);
                }
            }
            if (!bl) {
                return "";
            }
        }
        return this.throwableProxyToString(iThrowableProxy);
    }

    protected String throwableProxyToString(IThrowableProxy iThrowableProxy) {
        StringBuilder stringBuilder = new StringBuilder(2048);
        this.recursiveAppend(stringBuilder, null, 1, iThrowableProxy);
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private void recursiveAppend(StringBuilder stringBuilder, String object, int n, IThrowableProxy iThrowableProxy) {
        IThrowableProxy iThrowableProxy2;
        while (iThrowableProxy2 != null) {
            void var3_8;
            void var2_3;
            this.subjoinFirstLine(stringBuilder, (String)var2_3, (int)var3_8, iThrowableProxy2);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
            this.subjoinSTEPArray(stringBuilder, (int)var3_8, iThrowableProxy2);
            IThrowableProxy[] iThrowableProxyArray = iThrowableProxy2.getSuppressed();
            if (iThrowableProxyArray != null) {
                IThrowableProxy[] iThrowableProxyArray2 = iThrowableProxyArray;
                int n2 = iThrowableProxyArray.length;
                for (int i = 0; i < n2; ++i) {
                    IThrowableProxy iThrowableProxy3 = iThrowableProxyArray2[i];
                    this.recursiveAppend(stringBuilder, "Suppressed: ", (int)(var3_8 + true), iThrowableProxy3);
                }
            }
            iThrowableProxy2 = iThrowableProxy2.getCause();
            String string = "Caused by: ";
        }
        return;
    }

    private void subjoinFirstLine(StringBuilder stringBuilder, String string, int n, IThrowableProxy iThrowableProxy) {
        ThrowableProxyUtil.indent(stringBuilder, n - 1);
        if (string != null) {
            stringBuilder.append(string);
        }
        this.subjoinExceptionMessage(stringBuilder, iThrowableProxy);
    }

    private void subjoinExceptionMessage(StringBuilder stringBuilder, IThrowableProxy iThrowableProxy) {
        if (iThrowableProxy.isCyclic()) {
            stringBuilder.append("[CIRCULAR REFERENCE: ").append(iThrowableProxy.getClassName()).append(": ").append(iThrowableProxy.getMessage()).append(']');
            return;
        }
        stringBuilder.append(iThrowableProxy.getClassName()).append(": ").append(iThrowableProxy.getMessage());
    }

    protected void subjoinSTEPArray(StringBuilder stringBuilder, int n, IThrowableProxy iThrowableProxy) {
        int n2;
        StackTraceElementProxy[] stackTraceElementProxyArray = iThrowableProxy.getStackTraceElementProxyArray();
        int n3 = iThrowableProxy.getCommonFrames();
        boolean bl = this.lengthOption > stackTraceElementProxyArray.length;
        int n4 = n2 = bl ? stackTraceElementProxyArray.length : this.lengthOption;
        if (n3 > 0 && bl) {
            n2 -= n3;
        }
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            StackTraceElementProxy stackTraceElementProxy = stackTraceElementProxyArray[i];
            if (!this.isIgnoredStackTraceLine(stackTraceElementProxy.toString())) {
                ThrowableProxyUtil.indent(stringBuilder, n);
                this.printStackLine(stringBuilder, n5, stackTraceElementProxy);
                n5 = 0;
                stringBuilder.append(CoreConstants.LINE_SEPARATOR);
                continue;
            }
            ++n5;
            if (n2 >= stackTraceElementProxyArray.length) continue;
            ++n2;
        }
        if (n5 > 0) {
            this.printIgnoredCount(stringBuilder, n5);
            stringBuilder.append(CoreConstants.LINE_SEPARATOR);
        }
        if (n3 > 0 && bl) {
            ThrowableProxyUtil.indent(stringBuilder, n);
            stringBuilder.append("... ").append(iThrowableProxy.getCommonFrames()).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    private void printStackLine(StringBuilder stringBuilder, int n, StackTraceElementProxy stackTraceElementProxy) {
        stringBuilder.append(stackTraceElementProxy);
        this.extraData(stringBuilder, stackTraceElementProxy);
        if (n > 0) {
            this.printIgnoredCount(stringBuilder, n);
        }
    }

    private void printIgnoredCount(StringBuilder stringBuilder, int n) {
        stringBuilder.append(" [").append(n).append(" skipped]");
    }

    private boolean isIgnoredStackTraceLine(String string) {
        if (this.ignoredStackTraceLines != null) {
            for (String string2 : this.ignoredStackTraceLines) {
                if (!string.contains(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

