/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.util;

import io.ktor.util.TextKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000F\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\u0010\u0018\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0004\u001a\u001d\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000*\b\u0012\u0004\u0012\u00020\u00010\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a'\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0000*\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a!\u0010\u000b\u001a\u00020\n*\b\u0012\u0004\u0012\u00020\u00010\b2\u0006\u0010\t\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\u001a\u0013\u0010\u000e\u001a\u00020\r*\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000f\u001a\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013\u001a\u001c\u0010\u0016\u001a\u00020\r*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0014H\u0082\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017\"\u0014\u0010\u0018\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019\"\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\"\u0014\u0010\u001d\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u0019\u00a8\u0006\u001e"}, d2={"", "", "normalizePathComponents", "(Ljava/util/List;)Ljava/util/List;", "", "startIndex", "filterComponentsImpl", "(Ljava/util/List;I)Ljava/util/List;", "", "component", "", "processAndReplaceComponent", "(Ljava/util/List;Ljava/lang/String;)V", "", "shouldBeReplaced", "(Ljava/lang/String;)Z", "", "", "toASCIITable", "([C)[Z", "", "char", "contains", "([ZC)Z", "FirstReservedLetters", "[Z", "", "ReservedWords", "Ljava/util/Set;", "ReservedCharacters", "ktor-server-core"})
public final class PathsKt {
    private static final boolean[] FirstReservedLetters;
    private static final Set<String> ReservedWords;
    private static final boolean[] ReservedCharacters;

    public static final List<String> normalizePathComponents(List<String> list) {
        Intrinsics.checkNotNullParameter(list, (String)"");
        int n2 = ((Collection)list).size();
        for (int j = 0; j < n2; ++j) {
            String string = list.get(j);
            if (!PathsKt.shouldBeReplaced(string)) continue;
            return PathsKt.filterComponentsImpl(list, j);
        }
        return list;
    }

    private static final List<String> filterComponentsImpl(List<String> list, int n2) {
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        if (n2 > 0) {
            arrayList.addAll((Collection)list.subList(0, n2));
        }
        PathsKt.processAndReplaceComponent((List<String>)arrayList, list.get(n2));
        ++n2;
        int n3 = list.size();
        while (n2 < n3) {
            String string = list.get(n2);
            if (PathsKt.shouldBeReplaced(string)) {
                PathsKt.processAndReplaceComponent((List<String>)arrayList, string);
            } else {
                arrayList.add(string);
            }
            ++n2;
        }
        return arrayList;
    }

    private static final void processAndReplaceComponent(List<String> list, String charSequence) {
        CharSequence charSequence2;
        block7: {
            int n2;
            if (((CharSequence)charSequence).length() == 0 || Intrinsics.areEqual((Object)charSequence, (Object)".") || Intrinsics.areEqual((Object)charSequence, (Object)"~") || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules((String)charSequence))) {
                return;
            }
            if (Intrinsics.areEqual((Object)charSequence, (Object)"..")) {
                if (!((Collection)list).isEmpty()) {
                    List<String> list2 = list;
                    list2.remove(CollectionsKt.getLastIndex(list2));
                }
                return;
            }
            charSequence = charSequence;
            Appendable appendable = new StringBuilder();
            int n3 = charSequence.length();
            for (n2 = 0; n2 < n3; ++n2) {
                char c2;
                char c3 = c2 = charSequence.charAt(n2);
                if (!(Intrinsics.compare((int)c2, (int)32) >= 0 && !PathsKt.contains(ReservedCharacters, c3))) continue;
                appendable.append(c2);
            }
            charSequence = ((StringBuilder)appendable).toString();
            int n4 = (charSequence = (CharSequence)charSequence).length() + -1;
            if (n4 >= 0) {
                do {
                    n2 = n4--;
                    char c4 = charSequence.charAt(n2);
                    n3 = c4;
                    if (c4 == ' ' || n3 == 46) continue;
                    charSequence2 = charSequence.subSequence(0, n2 + 1);
                    break block7;
                } while (n4 >= 0);
            }
            charSequence2 = "";
        }
        charSequence = ((Object)charSequence2).toString();
        CharSequence charSequence3 = charSequence;
        if ((charSequence = ((CharSequence)charSequence).length() > 0 ? charSequence : null) != null) {
            charSequence3 = charSequence;
            list.add((String)charSequence3);
        }
    }

    private static final boolean shouldBeReplaced(String charSequence) {
        int n2 = ((String)charSequence).length();
        if (n2 == 0) {
            return true;
        }
        int n3 = ((String)charSequence).charAt(0);
        if (n3 == 46 && (n2 == 1 || n2 == 2 && ((String)charSequence).charAt(1) == '.')) {
            return true;
        }
        if (n3 == 126 && n2 == 1) {
            return true;
        }
        if (PathsKt.contains(FirstReservedLetters, (char)n3) && (ReservedWords.contains(charSequence) || ReservedWords.contains(TextKt.toUpperCasePreservingASCIIRules((String)charSequence)))) {
            return true;
        }
        char c2 = ((String)charSequence).charAt(n2 - 1);
        n2 = c2;
        switch (c2) {
            case ' ': 
            case '.': {
                return true;
            }
        }
        boolean[] blArray = ReservedCharacters;
        charSequence = charSequence;
        for (n3 = 0; n3 < charSequence.length(); ++n3) {
            char c3;
            char c4 = charSequence.charAt(n3);
            c4 = c4;
            if (!(Intrinsics.compare((int)c3, (int)32) < 0 || PathsKt.contains(blArray, c4))) continue;
            return true;
        }
        return false;
    }

    private static final boolean[] toASCIITable(char[] cArray) {
        int n2 = 0;
        boolean[] blArray = new boolean[256];
        while (n2 < 256) {
            int n3 = n2++;
            blArray[n3] = ArraysKt.contains((char[])cArray, (char)((char)n3));
        }
        return blArray;
    }

    private static final boolean contains(boolean[] blArray, char c2) {
        Intrinsics.checkNotNullParameter((Object)blArray, (String)"");
        return c2 < blArray.length && blArray[c2];
    }

    static {
        char[] cArray = new char[10];
        Object[] objectArray = cArray;
        cArray[0] = 65;
        objectArray[1] = 97;
        objectArray[2] = 67;
        objectArray[3] = 99;
        objectArray[4] = 108;
        objectArray[5] = 76;
        objectArray[6] = 80;
        objectArray[7] = 112;
        objectArray[8] = 110;
        objectArray[9] = 78;
        FirstReservedLetters = PathsKt.toASCIITable(objectArray);
        String[] stringArray = new String[22];
        objectArray = stringArray;
        stringArray[0] = "CON";
        objectArray[1] = (char)"PRN";
        objectArray[2] = (char)"AUX";
        objectArray[3] = (char)"NUL";
        objectArray[4] = (char)"COM1";
        objectArray[5] = (char)"COM2";
        objectArray[6] = (char)"COM3";
        objectArray[7] = (char)"COM4";
        objectArray[8] = (char)"COM5";
        objectArray[9] = (char)"COM6";
        objectArray[10] = (char)"COM7";
        objectArray[11] = (char)"COM8";
        objectArray[12] = (char)"COM9";
        objectArray[13] = (char)"LPT1";
        objectArray[14] = (char)"LPT2";
        objectArray[15] = (char)"LPT3";
        objectArray[16] = (char)"LPT4";
        objectArray[17] = (char)"LPT5";
        objectArray[18] = (char)"LPT6";
        objectArray[19] = (char)"LPT7";
        objectArray[20] = (char)"LPT8";
        objectArray[21] = (char)"LPT9";
        ReservedWords = SetsKt.setOf((Object[])objectArray);
        char[] cArray2 = new char[9];
        objectArray = cArray2;
        cArray2[0] = 92;
        objectArray[1] = 47;
        objectArray[2] = 58;
        objectArray[3] = 42;
        objectArray[4] = 63;
        objectArray[5] = 34;
        objectArray[6] = 60;
        objectArray[7] = 62;
        objectArray[8] = 124;
        ReservedCharacters = PathsKt.toASCIITable(objectArray);
    }
}

