/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.LineBasedFrameDecoder;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public class DelimiterBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteBuf[] delimiters;
    private final int maxFrameLength;
    private final boolean stripDelimiter;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private int tooLongFrameLength;
    private final LineBasedFrameDecoder lineBasedDecoder;

    public DelimiterBasedFrameDecoder(int n, ByteBuf byteBuf) {
        this(n, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n, boolean bl, ByteBuf byteBuf) {
        this(n, bl, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n, boolean bl, boolean bl2, ByteBuf byteBuf) {
        ByteBuf[] byteBufArray = new ByteBuf[1];
        ByteBuf byteBuf2 = byteBuf;
        byteBufArray[0] = byteBuf2.slice(byteBuf2.readerIndex(), byteBuf.readableBytes());
        this(n, bl, bl2, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n, ByteBuf ... byteBufArray) {
        this(n, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n, boolean bl, ByteBuf ... byteBufArray) {
        this(n, bl, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n, boolean bl, boolean bl2, ByteBuf ... byteBufArray) {
        DelimiterBasedFrameDecoder.validateMaxFrameLength(n);
        ObjectUtil.checkNonEmpty((Object[])byteBufArray, (String)"delimiters");
        if (DelimiterBasedFrameDecoder.isLineBased(byteBufArray) && !this.isSubclass()) {
            this.lineBasedDecoder = new LineBasedFrameDecoder(n, bl, bl2);
            this.delimiters = null;
        } else {
            this.delimiters = new ByteBuf[byteBufArray.length];
            for (int i = 0; i < byteBufArray.length; ++i) {
                ByteBuf byteBuf = byteBufArray[i];
                DelimiterBasedFrameDecoder.validateDelimiter(byteBuf);
                ByteBuf byteBuf2 = byteBuf;
                this.delimiters[i] = byteBuf2.slice(byteBuf2.readerIndex(), byteBuf.readableBytes());
            }
            this.lineBasedDecoder = null;
        }
        this.maxFrameLength = n;
        this.stripDelimiter = bl;
        this.failFast = bl2;
    }

    private static boolean isLineBased(ByteBuf[] byteBufArray) {
        if (byteBufArray.length != 2) {
            return false;
        }
        ByteBuf byteBuf = byteBufArray[0];
        ByteBuf byteBuf2 = byteBufArray[1];
        if (byteBuf.capacity() < byteBuf2.capacity()) {
            byteBuf = byteBufArray[1];
            byteBuf2 = byteBufArray[0];
        }
        return byteBuf.capacity() == 2 && byteBuf2.capacity() == 1 && byteBuf.getByte(0) == 13 && byteBuf.getByte(1) == 10 && byteBuf2.getByte(0) == 10;
    }

    private boolean isSubclass() {
        return ((Object)((Object)this)).getClass() != DelimiterBasedFrameDecoder.class;
    }

    @Override
    protected final void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        if ((object = this.decode((ChannelHandlerContext)object, byteBuf)) != null) {
            list.add(object);
        }
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        int n;
        if (this.lineBasedDecoder != null) {
            return this.lineBasedDecoder.decode(channelHandlerContext, byteBuf);
        }
        int n2 = Integer.MAX_VALUE;
        ByteBuf byteBuf2 = null;
        ByteBuf[] byteBufArray = this.delimiters;
        int n3 = this.delimiters.length;
        for (n = 0; n < n3; ++n) {
            ByteBuf byteBuf3 = byteBufArray[n];
            int n4 = DelimiterBasedFrameDecoder.indexOf(byteBuf, byteBuf3);
            if (n4 < 0 || n4 >= n2) continue;
            n2 = n4;
            byteBuf2 = byteBuf3;
        }
        if (byteBuf2 != null) {
            ByteBuf byteBuf4;
            int n5 = byteBuf2.capacity();
            if (this.discardingTooLongFrame) {
                this.discardingTooLongFrame = false;
                byteBuf.skipBytes(n2 + n5);
                n = this.tooLongFrameLength;
                this.tooLongFrameLength = 0;
                if (!this.failFast) {
                    this.fail(n);
                }
                return null;
            }
            if (n2 > this.maxFrameLength) {
                byteBuf.skipBytes(n2 + n5);
                this.fail(n2);
                return null;
            }
            if (this.stripDelimiter) {
                byteBuf4 = byteBuf.readRetainedSlice(n2);
                byteBuf.skipBytes(n5);
            } else {
                byteBuf4 = byteBuf.readRetainedSlice(n2 + n5);
            }
            return byteBuf4;
        }
        if (!this.discardingTooLongFrame) {
            if (byteBuf.readableBytes() > this.maxFrameLength) {
                this.tooLongFrameLength = byteBuf.readableBytes();
                ByteBuf byteBuf5 = byteBuf;
                byteBuf5.skipBytes(byteBuf5.readableBytes());
                this.discardingTooLongFrame = true;
                if (this.failFast) {
                    DelimiterBasedFrameDecoder delimiterBasedFrameDecoder = this;
                    delimiterBasedFrameDecoder.fail(delimiterBasedFrameDecoder.tooLongFrameLength);
                }
            }
        } else {
            this.tooLongFrameLength += byteBuf.readableBytes();
            ByteBuf byteBuf6 = byteBuf;
            byteBuf6.skipBytes(byteBuf6.readableBytes());
        }
        return null;
    }

    private void fail(long l) {
        if (l > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + l + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        int n = ByteBufUtil.indexOf((ByteBuf)byteBuf2, (ByteBuf)byteBuf);
        if (n == -1) {
            return -1;
        }
        return n - byteBuf.readerIndex();
    }

    private static void validateDelimiter(ByteBuf byteBuf) {
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"delimiter");
        if (!byteBuf.isReadable()) {
            throw new IllegalArgumentException("empty delimiter");
        }
    }

    private static void validateMaxFrameLength(int n) {
        ObjectUtil.checkPositive((int)n, (String)"maxFrameLength");
    }
}

