/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.handler.codec.Headers;
import io.netty.util.internal.ObjectUtil;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class HeadersUtils {
    private HeadersUtils() {
    }

    public static <K, V> List<String> getAllAsString(final Headers<K, V, ?> iterable, K k) {
        iterable = iterable.getAll(k);
        return new AbstractList<String>(){

            @Override
            public final String get(int n) {
                Object e = iterable.get(n);
                if (e != null) {
                    return e.toString();
                }
                return null;
            }

            @Override
            public final int size() {
                return iterable.size();
            }
        };
    }

    public static <K, V> String getAsString(Headers<K, V, ?> headers, K k) {
        if ((headers = headers.get(k)) != null) {
            return headers.toString();
        }
        return null;
    }

    public static Iterator<Map.Entry<String, String>> iteratorAsString(Iterable<Map.Entry<CharSequence, CharSequence>> iterable) {
        return new StringEntryIterator(iterable.iterator());
    }

    public static <K, V> String toString(Class<?> object, Iterator<Map.Entry<K, V>> iterator, int n) {
        object = ((Class)object).getSimpleName();
        if (n == 0) {
            return (String)object + "[]";
        }
        object = new StringBuilder(((String)object).length() + 2 + n * 20).append((String)object).append('[');
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            ((StringBuilder)object).append(entry.getKey()).append(": ").append(entry.getValue()).append(", ");
        }
        Object object2 = object;
        ((StringBuilder)object2).setLength(((StringBuilder)object2).length() - 2);
        return ((StringBuilder)object).append(']').toString();
    }

    public static Set<String> namesAsString(Headers<CharSequence, CharSequence, ?> headers) {
        return new DelegatingNameSet(headers);
    }

    private static final class DelegatingNameSet
    extends AbstractCollection<String>
    implements Set<String> {
        private final Headers<CharSequence, CharSequence, ?> headers;

        DelegatingNameSet(Headers<CharSequence, CharSequence, ?> headers) {
            this.headers = (Headers)ObjectUtil.checkNotNull(headers, (String)"headers");
        }

        @Override
        public final int size() {
            return this.headers.names().size();
        }

        @Override
        public final boolean isEmpty() {
            return this.headers.isEmpty();
        }

        @Override
        public final boolean contains(Object object) {
            return this.headers.contains(object.toString());
        }

        @Override
        public final Iterator<String> iterator() {
            return new StringIterator<CharSequence>(this.headers.names().iterator());
        }
    }

    private static final class StringIterator<T>
    implements Iterator<String> {
        private final Iterator<T> iter;

        StringIterator(Iterator<T> iterator) {
            this.iter = iterator;
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final String next() {
            T t = this.iter.next();
            if (t != null) {
                return t.toString();
            }
            return null;
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }

    private static final class StringEntry
    implements Map.Entry<String, String> {
        private final Map.Entry<CharSequence, CharSequence> entry;
        private String name;
        private String value;

        StringEntry(Map.Entry<CharSequence, CharSequence> entry) {
            this.entry = entry;
        }

        @Override
        public final String getKey() {
            if (this.name == null) {
                this.name = this.entry.getKey().toString();
            }
            return this.name;
        }

        @Override
        public final String getValue() {
            if (this.value == null && this.entry.getValue() != null) {
                this.value = this.entry.getValue().toString();
            }
            return this.value;
        }

        @Override
        public final String setValue(String string) {
            String string2 = this.getValue();
            this.entry.setValue(string);
            return string2;
        }

        public final String toString() {
            return this.entry.toString();
        }
    }

    private static final class StringEntryIterator
    implements Iterator<Map.Entry<String, String>> {
        private final Iterator<Map.Entry<CharSequence, CharSequence>> iter;

        StringEntryIterator(Iterator<Map.Entry<CharSequence, CharSequence>> iterator) {
            this.iter = iterator;
        }

        @Override
        public final boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public final Map.Entry<String, String> next() {
            return new StringEntry(this.iter.next());
        }

        @Override
        public final void remove() {
            this.iter.remove();
        }
    }
}

