/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.CompressionUtil;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

abstract class ByteBufChecksum
implements Checksum {
    private final ByteProcessor updateProcessor = new ByteProcessor(){

        public boolean process(byte by) {
            ByteBufChecksum.this.update(by);
            return true;
        }
    };

    ByteBufChecksum() {
    }

    private static Method updateByteBuffer(Checksum checksum) {
        if (PlatformDependent.javaVersion() >= 8) {
            try {
                Method method = checksum.getClass().getDeclaredMethod("update", ByteBuffer.class);
                method.invoke((Object)checksum, ByteBuffer.allocate(1));
                return method;
            }
            catch (Throwable throwable) {
                return null;
            }
        }
        return null;
    }

    static ByteBufChecksum wrapChecksum(Checksum checksum) {
        ObjectUtil.checkNotNull((Object)checksum, (String)"checksum");
        if (checksum instanceof ByteBufChecksum) {
            return (ByteBufChecksum)checksum;
        }
        if (checksum instanceof Adler32 && ZlibChecksumMethods.ADLER32_UPDATE_METHOD != null) {
            return new ReflectiveByteBufChecksum(checksum, ZlibChecksumMethods.ADLER32_UPDATE_METHOD);
        }
        if (checksum instanceof CRC32 && ZlibChecksumMethods.CRC32_UPDATE_METHOD != null) {
            return new ReflectiveByteBufChecksum(checksum, ZlibChecksumMethods.CRC32_UPDATE_METHOD);
        }
        return new SlowByteBufChecksum(checksum);
    }

    public void update(ByteBuf byteBuf, int n, int n2) {
        if (byteBuf.hasArray()) {
            this.update(byteBuf.array(), byteBuf.arrayOffset() + n, n2);
            return;
        }
        byteBuf.forEachByte(n, n2, this.updateProcessor);
    }

    static /* synthetic */ Method access$000(Checksum checksum) {
        return ByteBufChecksum.updateByteBuffer(checksum);
    }

    private static class SlowByteBufChecksum
    extends ByteBufChecksum {
        protected final Checksum checksum;

        SlowByteBufChecksum(Checksum checksum) {
            this.checksum = checksum;
        }

        @Override
        public void update(int n) {
            this.checksum.update(n);
        }

        @Override
        public void update(byte[] byArray, int n, int n2) {
            this.checksum.update(byArray, n, n2);
        }

        @Override
        public long getValue() {
            return this.checksum.getValue();
        }

        @Override
        public void reset() {
            this.checksum.reset();
        }
    }

    private static final class ReflectiveByteBufChecksum
    extends SlowByteBufChecksum {
        private final Method method;

        ReflectiveByteBufChecksum(Checksum checksum, Method method) {
            super(checksum);
            this.method = method;
        }

        @Override
        public final void update(ByteBuf byteBuf, int n, int n2) {
            if (byteBuf.hasArray()) {
                this.update(byteBuf.array(), byteBuf.arrayOffset() + n, n2);
                return;
            }
            try {
                this.method.invoke((Object)this.checksum, CompressionUtil.safeNioBuffer(byteBuf, n, n2));
                return;
            }
            catch (Throwable throwable) {
                throw new Error();
            }
        }
    }

    private static class ZlibChecksumMethods {
        private static final Method ADLER32_UPDATE_METHOD = ByteBufChecksum.access$000(new Adler32());
        private static final Method CRC32_UPDATE_METHOD = ByteBufChecksum.access$000(new CRC32());

        private ZlibChecksumMethods() {
        }
    }
}

