/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.DecompressionException;
import io.netty.handler.codec.compression.Snappy;
import java.util.List;

public class SnappyFrameDecoder
extends ByteToMessageDecoder {
    private static final int SNAPPY_IDENTIFIER_LEN = 6;
    private static final int MAX_UNCOMPRESSED_DATA_SIZE = 65540;
    private static final int MAX_DECOMPRESSED_DATA_SIZE = 65536;
    private static final int MAX_COMPRESSED_CHUNK_SIZE = 0xFFFFFF;
    private final Snappy snappy = new Snappy();
    private final boolean validateChecksums;
    private boolean started;
    private boolean corrupted;
    private int numBytesToSkip;

    public SnappyFrameDecoder() {
        this(false);
    }

    public SnappyFrameDecoder(boolean bl) {
        this.validateChecksums = bl;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void decode(ChannelHandlerContext var1_1, ByteBuf var2_4, List<Object> var3_6) {
        if (this.corrupted) {
            v0 = var2_4;
            v0.skipBytes(v0.readableBytes());
            return;
        }
        if (this.numBytesToSkip != 0) {
            var4_8 = Math.min(this.numBytesToSkip, var2_4.readableBytes());
            var2_4.skipBytes(var4_8);
            this.numBytesToSkip -= var4_8;
            return;
        }
        try {
            var4_9 = var2_4.readerIndex();
            var5_11 = var2_4.readableBytes();
            if (var5_11 < 4) {
                return;
            }
            var6_12 = var2_4.getUnsignedByte(var4_9);
            var7_13 = SnappyFrameDecoder.mapChunkType((byte)var6_12);
            var4_9 = var2_4.getUnsignedMediumLE(var4_9 + 1);
            switch (1.$SwitchMap$io$netty$handler$codec$compression$SnappyFrameDecoder$ChunkType[var7_13.ordinal()]) {
                case 1: {
                    if (var4_9 != 6) {
                        throw new DecompressionException("Unexpected length of stream identifier: " + var4_9);
                    }
                    if (var5_11 >= 10) {
                        var2_4.skipBytes(4);
                        var1_2 = var2_4.readerIndex();
                        var2_4.skipBytes(6);
                        SnappyFrameDecoder.checkByte(var2_4.getByte(var1_2++), (byte)115);
                        SnappyFrameDecoder.checkByte(var2_4.getByte(var1_2++), (byte)78);
                        SnappyFrameDecoder.checkByte(var2_4.getByte(var1_2++), (byte)97);
                        SnappyFrameDecoder.checkByte(var2_4.getByte(var1_2++), (byte)80);
                        SnappyFrameDecoder.checkByte(var2_4.getByte(var1_2++), (byte)112);
                        SnappyFrameDecoder.checkByte(var2_4.getByte(var1_2), (byte)89);
                        this.started = true;
                        break;
                    }
                    ** GOTO lbl112
                }
                case 2: {
                    if (!this.started) {
                        throw new DecompressionException("Received RESERVED_SKIPPABLE tag before STREAM_IDENTIFIER");
                    }
                    var2_4.skipBytes(4);
                    var1_3 = Math.min(var4_9, var2_4.readableBytes());
                    var2_4.skipBytes(var1_3);
                    if (var1_3 != var4_9) {
                        this.numBytesToSkip = var4_9 - var1_3;
                        break;
                    }
                    ** GOTO lbl112
                }
                case 3: {
                    throw new DecompressionException("Found reserved unskippable chunk type: 0x" + Integer.toHexString(var6_12));
                }
                case 4: {
                    if (!this.started) {
                        throw new DecompressionException("Received UNCOMPRESSED_DATA tag before STREAM_IDENTIFIER");
                    }
                    if (var4_9 > 65540) {
                        throw new DecompressionException("Received UNCOMPRESSED_DATA larger than 65540 bytes");
                    }
                    if (var5_11 < var4_9 + 4) {
                        return;
                    }
                    var2_4.skipBytes(4);
                    if (this.validateChecksums) {
                        var5_11 = var2_4.readIntLE();
                        v1 = var2_4;
                        Snappy.validateChecksum(var5_11, v1, v1.readerIndex(), var4_9 - 4);
                    } else {
                        var2_4.skipBytes(4);
                    }
                    var3_6.add(var2_4.readRetainedSlice(var4_9 - 4));
                    break;
                }
                case 5: {
                    if (!this.started) {
                        throw new DecompressionException("Received COMPRESSED_DATA tag before STREAM_IDENTIFIER");
                    }
                    if (var4_9 > 0xFFFFFF) {
                        throw new DecompressionException("Received COMPRESSED_DATA that contains chunk that exceeds 16777215 bytes");
                    }
                    if (var5_11 < var4_9 + 4) {
                        return;
                    }
                    var2_4.skipBytes(4);
                    var5_11 = var2_4.readIntLE();
                    var6_12 = this.snappy.getPreamble(var2_4);
                    if (var6_12 > 65536) {
                        throw new DecompressionException("Received COMPRESSED_DATA that contains uncompressed data that exceeds 65536 bytes");
                    }
                    var1_1 = var1_1.alloc().buffer(var6_12, 65536);
                    try {
                        if (!this.validateChecksums) ** GOTO lbl101
                        var6_12 = var2_4.writerIndex();
                        try {
                            v2 = var2_4;
                            v2.writerIndex(v2.readerIndex() + var4_9 - 4);
                            this.snappy.decode(var2_4, (ByteBuf)var1_1);
                        }
                        finally {
                            var2_4.writerIndex(var6_12);
                        }
                        Snappy.validateChecksum(var5_11, (ByteBuf)var1_1, 0, var1_1.writerIndex());
                        ** GOTO lbl102
lbl101:
                        // 1 sources

                        this.snappy.decode(var2_4.readSlice(var4_9 - 4), (ByteBuf)var1_1);
lbl102:
                        // 2 sources

                        var3_6.add(var1_1);
                        var1_1 = null;
                    }
                    catch (Throwable var2_5) {
                        if (var1_1 != null) {
                            var1_1.release();
                        }
                        throw var2_5;
                    }
                    this.snappy.reset();
                }
lbl112:
                // 4 sources

                default: {
                    return;
                }
            }
        }
        catch (Exception var4_10) {
            this.corrupted = true;
            throw var4_10;
        }
    }

    private static void checkByte(byte by, byte by2) {
        if (by != by2) {
            throw new DecompressionException("Unexpected stream identifier contents. Mismatched snappy protocol version?");
        }
    }

    private static ChunkType mapChunkType(byte by) {
        if (by == 0) {
            return ChunkType.COMPRESSED_DATA;
        }
        if (by == 1) {
            return ChunkType.UNCOMPRESSED_DATA;
        }
        if (by == -1) {
            return ChunkType.STREAM_IDENTIFIER;
        }
        if ((by & 0x80) == 128) {
            return ChunkType.RESERVED_SKIPPABLE;
        }
        return ChunkType.RESERVED_UNSKIPPABLE;
    }

    private static enum ChunkType {
        STREAM_IDENTIFIER,
        COMPRESSED_DATA,
        UNCOMPRESSED_DATA,
        RESERVED_UNSKIPPABLE,
        RESERVED_SKIPPABLE;

    }
}

