/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.encoder.Encoder;
import io.netty.handler.codec.compression.BrotliMode;
import io.netty.handler.codec.compression.BrotliOptions;
import io.netty.handler.codec.compression.DeflateOptions;
import io.netty.handler.codec.compression.GzipOptions;
import io.netty.handler.codec.compression.SnappyOptions;
import io.netty.handler.codec.compression.ZstdOptions;
import io.netty.util.internal.ObjectUtil;

public final class StandardCompressionOptions {
    private StandardCompressionOptions() {
    }

    public static BrotliOptions brotli() {
        return BrotliOptions.DEFAULT;
    }

    @Deprecated
    public static BrotliOptions brotli(Encoder.Parameters parameters) {
        return new BrotliOptions(parameters);
    }

    public static BrotliOptions brotli(int n, int n2, BrotliMode brotliMode) {
        ObjectUtil.checkInRange((int)n, (int)0, (int)11, (String)"quality");
        ObjectUtil.checkInRange((int)n2, (int)10, (int)24, (String)"window");
        ObjectUtil.checkNotNull((Object)((Object)brotliMode), (String)"mode");
        Encoder.Parameters parameters = new Encoder.Parameters().setQuality(n).setWindow(n2).setMode(brotliMode.adapt());
        return new BrotliOptions(parameters);
    }

    public static ZstdOptions zstd() {
        return ZstdOptions.DEFAULT;
    }

    public static ZstdOptions zstd(int n, int n2, int n3) {
        return new ZstdOptions(n, n2, n3);
    }

    public static SnappyOptions snappy() {
        return new SnappyOptions();
    }

    public static GzipOptions gzip() {
        return GzipOptions.DEFAULT;
    }

    public static GzipOptions gzip(int n, int n2, int n3) {
        return new GzipOptions(n, n2, n3);
    }

    public static DeflateOptions deflate() {
        return DeflateOptions.DEFAULT;
    }

    public static DeflateOptions deflate(int n, int n2, int n3) {
        return new DeflateOptions(n, n2, n3);
    }
}

