/*
 * Decompiled with CFR 0.152.
 */
package org.sqlite.jdbc3;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sqlite.ExtendedCommand;
import org.sqlite.SQLiteConnection;
import org.sqlite.core.CoreStatement;
import org.sqlite.core.DB;

public abstract class JDBC3Statement
extends CoreStatement {
    private int queryTimeout = 0;
    protected long updateCount;
    protected boolean exhaustedResults = false;

    protected JDBC3Statement(SQLiteConnection sQLiteConnection) {
        super(sQLiteConnection);
    }

    public void close() {
        this.clearGeneratedKeys();
        this.internalClose();
    }

    public boolean execute(String string) {
        this.internalClose();
        JDBC3Statement jDBC3Statement = this;
        return jDBC3Statement.withConnectionTimeout(() -> {
            ExtendedCommand.SQLExtension sQLExtension = ExtendedCommand.parse(string);
            if (sQLExtension != null) {
                sQLExtension.execute(this.conn.getDatabase());
                return Boolean.FALSE;
            }
            this.sql = string;
            string = this.conn;
            synchronized (string) {
                this.conn.getDatabase().prepare(this);
                boolean bl = this.exec();
                this.updateGeneratedKeys();
                this.updateCount = this.getDatabase().changes();
                this.exhaustedResults = false;
                return bl;
            }
        });
    }

    public boolean execute(String string, int n) {
        return this.execute(string);
    }

    @Override
    public ResultSet executeQuery(String string, boolean bl) {
        this.rs.closeStmt = bl;
        return this.executeQuery(string);
    }

    public ResultSet executeQuery(String string) {
        this.internalClose();
        this.sql = string;
        JDBC3Statement jDBC3Statement = this;
        return jDBC3Statement.withConnectionTimeout(() -> {
            this.conn.getDatabase().prepare(this);
            if (!this.exec()) {
                this.internalClose();
                throw new SQLException("query does not return ResultSet", "SQLITE_DONE", 101);
            }
            this.exhaustedResults = false;
            return this.getResultSet();
        });
    }

    public int executeUpdate(String string) {
        return (int)this.executeLargeUpdate(string);
    }

    public int executeUpdate(String string, int n) {
        return this.executeUpdate(string);
    }

    public long executeLargeUpdate(String string) {
        this.internalClose();
        this.sql = string;
        JDBC3Statement jDBC3Statement = this;
        return jDBC3Statement.withConnectionTimeout(() -> {
            DB dB = this.conn.getDatabase();
            long l = 0L;
            Object object = ExtendedCommand.parse(string);
            if (object != null) {
                object.execute(dB);
            } else {
                try {
                    object = dB;
                    synchronized (object) {
                        l = dB.total_changes();
                        int n = dB._exec(string);
                        if (n != 0) {
                            throw DB.newSQLException(n, "");
                        }
                        this.updateGeneratedKeys();
                        l = dB.total_changes() - l;
                    }
                }
                finally {
                    this.internalClose();
                }
            }
            return l;
        });
    }

    public long executeLargeUpdate(String string, int n) {
        return this.executeLargeUpdate(string);
    }

    public ResultSet getResultSet() {
        this.checkOpen();
        if (this.exhaustedResults) {
            return null;
        }
        if (this.rs.isOpen()) {
            throw new SQLException("ResultSet already requested");
        }
        if (this.pointer.safeRunInt(DB::column_count) == 0) {
            return null;
        }
        if (this.rs.colsMeta == null) {
            this.rs.colsMeta = this.pointer.safeRun(DB::column_names);
        }
        this.rs.cols = this.rs.colsMeta;
        this.rs.emptyResultSet = !this.resultsWaiting;
        this.rs.open = true;
        this.resultsWaiting = false;
        return (ResultSet)((Object)this.rs);
    }

    public int getUpdateCount() {
        return (int)this.getLargeUpdateCount();
    }

    public long getLargeUpdateCount() {
        this.conn.getDatabase();
        if (!(this.pointer.isClosed() || this.rs.isOpen() || this.resultsWaiting || this.pointer.safeRunInt(DB::column_count) != 0)) {
            return this.updateCount;
        }
        return -1L;
    }

    public void addBatch(String string) {
        this.internalClose();
        if (this.batch == null || this.batchPos + 1 >= this.batch.length) {
            Object[] objectArray = new Object[Math.max(10, this.batchPos << 1)];
            if (this.batch != null) {
                System.arraycopy(this.batch, 0, objectArray, 0, this.batch.length);
            }
            this.batch = objectArray;
        }
        this.batch[this.batchPos++] = string;
    }

    public void clearBatch() {
        this.batchPos = 0;
        if (this.batch != null) {
            for (int i = 0; i < this.batch.length; ++i) {
                this.batch[i] = null;
            }
        }
    }

    public int[] executeBatch() {
        return Arrays.stream(this.executeLargeBatch()).mapToInt(l -> (int)l).toArray();
    }

    public long[] executeLargeBatch() {
        DB dB;
        this.internalClose();
        if (this.batch == null || this.batchPos == 0) {
            return new long[0];
        }
        long[] lArray = new long[this.batchPos];
        DB dB2 = dB = this.conn.getDatabase();
        synchronized (dB) {
            try {
                for (int i = 0; i < lArray.length; ++i) {
                    try {
                        this.sql = (String)this.batch[i];
                        dB.prepare(this);
                        lArray[i] = dB.executeUpdate(this, null);
                        continue;
                    }
                    catch (SQLException sQLException) {
                        throw new BatchUpdateException("batch entry " + i + ": " + sQLException.getMessage(), null, 0, lArray, (Throwable)sQLException);
                    }
                    finally {
                        if (this.pointer != null) {
                            this.pointer.close();
                        }
                    }
                }
            }
            finally {
                this.clearBatch();
            }
            // ** MonitorExit[var3_7] (shouldn't be in output)
            return lArray;
        }
    }

    public void setCursorName(String string) {
    }

    public SQLWarning getWarnings() {
        return null;
    }

    public void clearWarnings() {
    }

    public Connection getConnection() {
        return this.conn;
    }

    public void cancel() {
        this.conn.getDatabase().interrupt();
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) {
        if (n < 0) {
            throw new SQLException("query timeout must be >= 0");
        }
        this.queryTimeout = n;
    }

    public int getMaxRows() {
        return (int)this.rs.maxRows;
    }

    public long getLargeMaxRows() {
        return this.rs.maxRows;
    }

    public void setMaxRows(int n) {
        this.setLargeMaxRows(n);
    }

    public void setLargeMaxRows(long l) {
        if (l < 0L) {
            throw new SQLException("max row count must be >= 0");
        }
        this.rs.maxRows = l;
    }

    public int getMaxFieldSize() {
        return 0;
    }

    public void setMaxFieldSize(int n) {
        if (n < 0) {
            throw new SQLException("max field size " + n + " cannot be negative");
        }
    }

    public int getFetchSize() {
        return ((ResultSet)((Object)this.rs)).getFetchSize();
    }

    public void setFetchSize(int n) {
        ((ResultSet)((Object)this.rs)).setFetchSize(n);
    }

    public int getFetchDirection() {
        return 1000;
    }

    public void setFetchDirection(int n) {
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                return;
            }
        }
        throw new SQLException("Unknown fetch direction " + n + ". Must be one of FETCH_FORWARD, FETCH_REVERSE, or FETCH_UNKNOWN in java.sql.ResultSet");
    }

    public boolean getMoreResults() {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int n) {
        this.checkOpen();
        if (n == 2 || n == 3) {
            throw new SQLFeatureNotSupportedException("Argument not supported: Statement.KEEP_CURRENT_RESULT or Statement.CLOSE_ALL_RESULTS");
        }
        if (n != 1) {
            throw new SQLException("Invalid argument");
        }
        this.rs.close();
        this.updateCount = -1L;
        this.exhaustedResults = true;
        return false;
    }

    public int getResultSetConcurrency() {
        return 1007;
    }

    public int getResultSetHoldability() {
        return 2;
    }

    public int getResultSetType() {
        return 1003;
    }

    public void setEscapeProcessing(boolean bl) {
    }

    protected SQLException unsupported() {
        return new SQLFeatureNotSupportedException("not implemented by SQLite JDBC driver");
    }

    public boolean execute(String string, int[] nArray) {
        throw this.unsupported();
    }

    public boolean execute(String string, String[] stringArray) {
        throw this.unsupported();
    }

    public int executeUpdate(String string, int[] nArray) {
        throw this.unsupported();
    }

    public int executeUpdate(String string, String[] stringArray) {
        throw this.unsupported();
    }

    public long executeLargeUpdate(String string, int[] nArray) {
        throw this.unsupported();
    }

    public long executeLargeUpdate(String string, String[] stringArray) {
        throw this.unsupported();
    }

    protected <T> T withConnectionTimeout(SQLCallable<T> sQLCallable) {
        int n = this.conn.getBusyTimeout();
        if (this.queryTimeout > 0) {
            this.conn.setBusyTimeout(1000 * this.queryTimeout);
        }
        try {
            sQLCallable = sQLCallable.call();
            return (T)sQLCallable;
        }
        finally {
            if (this.queryTimeout > 0) {
                this.conn.setBusyTimeout(n);
            }
        }
    }

    @FunctionalInterface
    protected static interface SQLCallable<T> {
        public T call();
    }

    static class BackupObserver
    implements DB.ProgressObserver {
        private static final Logger logger = LoggerFactory.getLogger(BackupObserver.class);

        BackupObserver() {
        }

        @Override
        public void progress(int n, int n2) {
            logger.info("remaining:{}, page count:{}", (Object)n, (Object)n2);
        }
    }
}

