/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractByteBuf;
import io.netty.buffer.AbstractByteBufAllocator;
import io.netty.buffer.AdaptivePoolingAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufAllocatorMetric;
import io.netty.buffer.ByteBufAllocatorMetricProvider;
import io.netty.buffer.UnpooledDirectByteBuf;
import io.netty.buffer.UnpooledHeapByteBuf;
import io.netty.buffer.UnpooledUnsafeHeapByteBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;

public final class AdaptiveByteBufAllocator
extends AbstractByteBufAllocator
implements ByteBufAllocatorMetric,
ByteBufAllocatorMetricProvider {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AdaptiveByteBufAllocator.class);
    private static final boolean DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS = SystemPropertyUtil.getBoolean((String)"io.netty.allocator.useCachedMagazinesForNonEventLoopThreads", (boolean)false);
    private final AdaptiveAllocatorApi direct;
    private final AdaptiveAllocatorApi heap;

    public AdaptiveByteBufAllocator() {
        this(PlatformDependent.directBufferPreferred());
    }

    public AdaptiveByteBufAllocator(boolean bl) {
        this(bl, DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
    }

    public AdaptiveByteBufAllocator(boolean bl, boolean bl2) {
        super(bl);
        if (PlatformDependent.javaVersion() < 8) {
            throw new IllegalStateException("This allocator require Java 8 or newer.");
        }
        AdaptivePoolingAllocator.MagazineCaching magazineCaching = bl2 ? AdaptivePoolingAllocator.MagazineCaching.FastThreadLocalThreads : AdaptivePoolingAllocator.MagazineCaching.EventLoopThreads;
        this.direct = new AdaptivePoolingAllocator(new DirectChunkAllocator(this), magazineCaching);
        this.heap = new AdaptivePoolingAllocator(new HeapChunkAllocator(this), magazineCaching);
    }

    @Override
    protected final ByteBuf newHeapBuffer(int n, int n2) {
        return this.heap.allocate(n, n2);
    }

    @Override
    protected final ByteBuf newDirectBuffer(int n, int n2) {
        return this.direct.allocate(n, n2);
    }

    @Override
    public final boolean isDirectBufferPooled() {
        return true;
    }

    @Override
    public final long usedHeapMemory() {
        return this.heap.usedMemory();
    }

    @Override
    public final long usedDirectMemory() {
        return this.direct.usedMemory();
    }

    @Override
    public final ByteBufAllocatorMetric metric() {
        return this;
    }

    static {
        logger.debug("-Dio.netty.allocator.useCachedMagazinesForNonEventLoopThreads: {}", (Object)DEFAULT_USE_CACHED_MAGAZINES_FOR_NON_EVENT_LOOP_THREADS);
    }

    private static final class DirectChunkAllocator
    implements AdaptivePoolingAllocator.ChunkAllocator {
        private final ByteBufAllocator allocator;

        private DirectChunkAllocator(ByteBufAllocator byteBufAllocator) {
            this.allocator = byteBufAllocator;
        }

        @Override
        public final AbstractByteBuf allocate(int n, int n2) {
            if (PlatformDependent.hasUnsafe()) {
                return UnsafeByteBufUtil.newUnsafeDirectByteBuf(this.allocator, n, n2);
            }
            return new UnpooledDirectByteBuf(this.allocator, n, n2);
        }
    }

    private static final class HeapChunkAllocator
    implements AdaptivePoolingAllocator.ChunkAllocator {
        private final ByteBufAllocator allocator;

        private HeapChunkAllocator(ByteBufAllocator byteBufAllocator) {
            this.allocator = byteBufAllocator;
        }

        @Override
        public final AbstractByteBuf allocate(int n, int n2) {
            if (PlatformDependent.hasUnsafe()) {
                return new UnpooledUnsafeHeapByteBuf(this.allocator, n, n2);
            }
            return new UnpooledHeapByteBuf(this.allocator, n, n2);
        }
    }

    static interface AdaptiveAllocatorApi {
        public ByteBuf allocate(int var1, int var2);

        public long usedMemory();
    }
}

