/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ReadOnlyByteBufferBuf;
import io.netty.buffer.UnsafeByteBufUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import java.nio.ByteBuffer;

final class ReadOnlyUnsafeDirectByteBuf
extends ReadOnlyByteBufferBuf {
    private final long memoryAddress;

    ReadOnlyUnsafeDirectByteBuf(ByteBufAllocator byteBufAllocator, ByteBuffer byteBuffer) {
        super(byteBufAllocator, byteBuffer);
        this.memoryAddress = PlatformDependent.directBufferAddress((ByteBuffer)this.buffer);
    }

    @Override
    protected final byte _getByte(int n) {
        return UnsafeByteBufUtil.getByte(this.addr(n));
    }

    @Override
    protected final short _getShort(int n) {
        return UnsafeByteBufUtil.getShort(this.addr(n));
    }

    @Override
    protected final int _getUnsignedMedium(int n) {
        return UnsafeByteBufUtil.getUnsignedMedium(this.addr(n));
    }

    @Override
    protected final int _getInt(int n) {
        return UnsafeByteBufUtil.getInt(this.addr(n));
    }

    @Override
    protected final long _getLong(int n) {
        return UnsafeByteBufUtil.getLong(this.addr(n));
    }

    @Override
    protected final ByteBuf getBytes(int n, ByteBuf byteBuf, int n2, int n3, boolean bl) {
        this.checkIndex(n, n3);
        ObjectUtil.checkNotNull((Object)byteBuf, (String)"dst");
        if (n2 < 0 || n2 > byteBuf.capacity() - n3) {
            throw new IndexOutOfBoundsException("dstIndex: " + n2);
        }
        if (byteBuf.hasMemoryAddress()) {
            PlatformDependent.copyMemory((long)this.addr(n), (long)(byteBuf.memoryAddress() + (long)n2), (long)n3);
        } else if (byteBuf.hasArray()) {
            PlatformDependent.copyMemory((long)this.addr(n), (byte[])byteBuf.array(), (int)(byteBuf.arrayOffset() + n2), (long)n3);
        } else {
            byteBuf.setBytes(n2, this, n, n3);
        }
        return this;
    }

    @Override
    protected final ByteBuf getBytes(int n, byte[] byArray, int n2, int n3, boolean bl) {
        this.checkIndex(n, n3);
        ObjectUtil.checkNotNull((Object)byArray, (String)"dst");
        if (n2 < 0 || n2 > byArray.length - n3) {
            throw new IndexOutOfBoundsException(String.format("dstIndex: %d, length: %d (expected: range(0, %d))", n2, n3, byArray.length));
        }
        if (n3 != 0) {
            PlatformDependent.copyMemory((long)this.addr(n), (byte[])byArray, (int)n2, (long)n3);
        }
        return this;
    }

    @Override
    public final ByteBuf copy(int n, int n2) {
        this.checkIndex(n, n2);
        ByteBuf byteBuf = ((ByteBuf)this).alloc().directBuffer(n2, ((ByteBuf)this).maxCapacity());
        if (n2 != 0) {
            if (byteBuf.hasMemoryAddress()) {
                PlatformDependent.copyMemory((long)this.addr(n), (long)byteBuf.memoryAddress(), (long)n2);
                byteBuf.setIndex(0, n2);
            } else {
                byteBuf.writeBytes(this, n, n2);
            }
        }
        return byteBuf;
    }

    @Override
    public final boolean hasMemoryAddress() {
        return true;
    }

    @Override
    public final long memoryAddress() {
        return this.memoryAddress;
    }

    private long addr(int n) {
        return this.memoryAddress + (long)n;
    }
}

